# Take input 

w1, h1 = map(int, input().split())
pict1 = [list(map(int, list(input()))) for _ in range(h1)]

w2, h2 = map(int, input().split())
pict2 = [list(map(int, list(input()))) for _ in range(h2)]

# Preprocess second picture to a list of coin positions instead of
# Full picture of coins, as the picture is sparse.
coins_pos = [(i, j) for j in range(h2) for i in range(w2) if pict2[j][i]]

counts = dict()

# Iterate over picture and count how much different positions of image 2
# Intersect with picture 1

for i in range(w1):
    for j in range(h1):
        if pict1[j][i]:
            for x, y in coins_pos:
                nx = i - x
                ny = j - y
                if not (nx, ny) in counts:
                    counts[(nx, ny)] = 1
                else:
                    counts[(nx, ny)] += 1

# Print the least number of coin changes necessary
print(len(coins_pos) - max(counts.values()))